<?php
// Determine whether we're upgrading or not
$isUpgrade = (bool)self::$vbulletin->products['dbtech_downloads'];

// Add the administrator field
if (self::$db_alter->fetch_table_info('administrator'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_downloadsadminperms',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'administrator');
}

if (self::$db_alter->fetch_table_info('user') AND $isUpgrade)
{	
	self::$db->hide_errors();
	self::$db->query_write("ALTER TABLE " . TABLE_PREFIX . "user CHANGE dbtech_downloads_download_size_today dbtech_downloads_download_size_today INT(10) NOT NULL DEFAULT '0'");
	self::$db->query_write("ALTER TABLE " . TABLE_PREFIX . "user CHANGE dbtech_downloads_banned dbtech_downloads_banned TINYINT(1) NOT NULL DEFAULT '0'");
	self::$db->query_write("UPDATE " . TABLE_PREFIX . "user SET dbtech_downloads_banned = IF(dbtech_downloads_banned = '2', '1', '0')");
	self::$db->show_errors();
	self::report('Altered Table', 'user');
}

if (self::$db_alter->fetch_table_info('usergroup'))
{
	if ($isUpgrade)
	{
		self::$db->hide_errors();
		self::$db->query_write("ALTER TABLE " . TABLE_PREFIX . "usergroup CHANGE dbtech_downloads_downloadsperday dbtech_downloads_downloadsperday INT(10) NOT NULL DEFAULT '0'");
		self::$db->query_write("ALTER TABLE " . TABLE_PREFIX . "usergroup CHANGE dbtech_downloads_downloadsizeperday dbtech_downloads_downloadsizeperday INT(10) NOT NULL DEFAULT '0'");
		self::$db->show_errors();
	}

	self::$db_alter->add_field(array(
		'name'       => 'dbtech_downloadspermissions',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'usergroup');
}



// New tables
self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_category` (
		`categoryid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`title` VARCHAR(150) NOT NULL DEFAULT '',
		`description` TEXT NOT NULL,
		`extensiongroups` BLOB NOT NULL DEFAULT '',
		`canprivate` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
		`canpassword` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
		`moderation` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
		`permissions` BLOB NOT NULL DEFAULT '',
		`parentid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`forumid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`image` VARCHAR(100) NOT NULL DEFAULT '',
		PRIMARY KEY (`categoryid`)
	)
");
self::report('Created Table', 'dbtech_downloads_category');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_comment` (
		`commentid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`userid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`downloadid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`comment` MEDIUMTEXT NOT NULL,
		`dateline` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		PRIMARY KEY (`commentid`)
	)
");
self::report('Created Table', 'dbtech_downloads_comment');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_delay` (
		`userid` INT(10) UNSIGNED NOT NULL,
		`fileid` INT(10) UNSIGNED NOT NULL,
		`dateline` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		PRIMARY KEY (`userid`, `fileid`)
	)
");
self::report('Created Table', 'dbtech_downloads_delay');


self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_download` (
		`downloadid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`userid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`title` VARCHAR(100) NOT NULL,
		`description` TEXT NOT NULL,
		`totaldownloads` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`files` TEXT NOT NULL,
		`numfiles` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`image` TEXT NOT NULL,
		`rating` INT(10) NOT NULL DEFAULT '0',
		`updated` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`categoryid` INT(10) NOT NULL,
		`moderation` TINYINT(1) NOT NULL DEFAULT '0',
		`password` CHAR(32) NOT NULL DEFAULT '',
		`private` BLOB NOT NULL DEFAULT '',
		`numfavourites` INT(10) NULL DEFAULT '0',
		`mirrors` BLOB NOT NULL DEFAULT '',
		PRIMARY KEY (`downloadid`),
		KEY `userid` (`userid`)
	)
");
self::report('Created Table', 'dbtech_downloads_download');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_downloadlog` (
		`downloadlogid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`userid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`fileid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`downloadid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`ipaddress` CHAR(15) NOT NULL DEFAULT '',
		`dateline` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`filesize` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		PRIMARY KEY (`downloadlogid`)
	)
");
self::report('Created Table', 'dbtech_downloads_downloadlog');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_extension` (
		`extensionid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`extension` VARCHAR(10) NOT NULL DEFAULT '',
		`mime` VARCHAR(100) NOT NULL DEFAULT '',
		`maxsize` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`maxheight` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`maxwidth` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`isimage` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
		`extensiongroupid` INT(10) UNSIGNED NOT NULL,
		PRIMARY KEY (`extensionid`)
	)
");
self::report('Created Table', 'dbtech_downloads_extension');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_extensiongroup` (
		`extensiongroupid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`title` VARCHAR(50) NOT NULL,
		PRIMARY KEY (`extensiongroupid`)
	)
");
self::report('Created Table', 'dbtech_downloads_extensiongroup');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_favourite` (
		`userid` INT(10) UNSIGNED NOT NULL,
		`downloadid` INT(10) UNSIGNED NOT NULL,
		PRIMARY KEY (`userid`, `downloadid`)
	)
");
self::report('Created Table', 'dbtech_downloads_favourite');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_file` (
		`fileid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`userid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`filename` TEXT NOT NULL DEFAULT '',
		`dateline` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`filesize` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`filetype` VARCHAR(100) NULL DEFAULT NULL,
		`private` TINYINT(1) NOT NULL DEFAULT '0',
		`privateusers` BLOB NOT NULL DEFAULT '',
		`downloads` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`image` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
		`downloadid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`screenshot` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
		PRIMARY KEY (`fileid`)
	)
");
self::report('Created Table', 'dbtech_downloads_file');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_rating` (
		`userid` INT(10) UNSIGNED NOT NULL,
		`downloadid` INT(10) UNSIGNED NOT NULL,
		PRIMARY KEY (`userid`, `downloadid`)
	)
");
self::report('Created Table', 'dbtech_downloads_rating');

self::$db->query_write("DROP TABLE IF EXISTS `" . TABLE_PREFIX . "dbtech_downloads_report`");
self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_report` (
		`reportid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`type` ENUM('file', 'comment', 'link') NOT NULL DEFAULT 'file',
		`userid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`targetid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`reason` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
		`dateline` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		PRIMARY KEY (`reportid`)
	)
");
self::report('Re-created Table', 'dbtech_downloads_report');


if ($isUpgrade)
{
	// Drop
	$tables = array(
		'categories' 		=> 'category',
		'comments' 			=> 'comment',
		'extensions' 		=> 'extension',
		'extension_groups' 	=> 'extensiongroup',
		'filegroup' 		=> 'download',
		'fileinfo' 			=> 'file',
		'filequeue' 		=> 'delay',
	);
	foreach ($tables as $oldTable => $newTable)
	{
		if (self::$db_alter->fetch_table_info('dbtech_downloads_' . $oldTable))
		{
			self::$db->query_write("
				REPLACE INTO " . TABLE_PREFIX . "dbtech_downloads_$newTable
				SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_$oldTable
			");
			self::report('Populated Table', 'dbtech_downloads_' . $newTable);
		}
	}

	if (self::$db_alter->fetch_table_info('dbtech_downloads_ratings'))
	{
		self::$db->query_write("
			REPLACE INTO " . TABLE_PREFIX . "dbtech_downloads_rating
			SELECT userid, fileid FROM " . TABLE_PREFIX . "dbtech_downloads_ratings
		");
		self::report('Populated Table', 'dbtech_downloads_rating');
	}

	foreach (array(
		'category' => array('canprivate', 'canpassword', 'moderation'),
		'download' => array('moderation'),
		'file' => array('screenshot'),
	) AS $table => $tableInfo)
	{
		$cols = array();
		foreach ($tableInfo as $col)
		{
			$cols[] = $col . " = IF($col = '2', '1', '0')";
		}

		// Run cleanups
		self::$db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_downloads_$table
			SET " . implode(', ', $cols) . "
		");
		self::report('Cleaned Up Table', 'dbtech_downloads_' . $table);
	}

	$categories_q = self::$db->query_read_slave("
		SELECT categoryid, extensiongroups
		FROM " . TABLE_PREFIX . "dbtech_downloads_category
	");
	while ($category = self::$db->fetch_array($categories_q))
	{
		self::$db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_downloads_category 
			SET extensiongroups = '" . self::$db->escape_string(trim(serialize(explode(',', $category['extensiongroups'])))) . "' 
			WHERE categoryid = " . $category['categoryid']
		);
		self::report('Updated Table', 'dbtech_downloads_category');
	}

	self::$db->query_write("
		UPDATE " . TABLE_PREFIX . "dbtech_downloads_file AS file 
		SET file.userid = (
			SELECT userid 
			FROM " . TABLE_PREFIX . "dbtech_downloads_download AS download
			WHERE download.downloadid = file.downloadid
		)
		WHERE file.userid = 0
	");
	self::report('Cleaned Up Table', 'dbtech_downloads_file');

	self::$db->query_write("DELETE FROM " . TABLE_PREFIX . "dbtech_downloads_rating WHERE userid = 0");
	self::report('Cleaned Up Table', 'dbtech_downloads_rating');
}
else
{
	self::$db->query_write("
		INSERT IGNORE INTO `" . TABLE_PREFIX . "dbtech_downloads_category` 
			(categoryid, title, description)
		VALUES 
			(1, 'Default Category', 'Category added at installation')
	");
	self::report('Populated Table', 'dbtech_downloads_category');

	self::$db->query_write("
		INSERT IGNORE INTO `" . TABLE_PREFIX . "dbtech_downloads_extension` 
			(`extensionid`, `extension`, `mime`, `maxsize`, `maxheight`, `maxwidth`, `isimage`, `extensiongroupid`) 
		VALUES 
			(1, 'png', 'image/png', 5242880, 1000, 700, 1, 1),
			(2, 'gif', 'image/gif', 5242880, 1000, 700, 1, 1),
			(3, 'jpeg', 'image/jpeg', 5242880, 1000, 700, 1, 1),
			(4, 'avi', 'video/x-msvideo', 5242880, 0, 0, 0, 3),
			(5, 'zip', 'application/zip', 5242880, 0, 0, 0, 2),
			(6, 'jpg', 'image/jpeg', 5242880, 1000, 700, 1, 1),
			(7, 'mpeg', 'video/mpeg', 5242880, 0, 0, 0, 3),
			(8, 'pdf', 'application/pdf', 5242880, 0, 0, 0, 2)
	");
	self::report('Populated Table', 'dbtech_downloads_extension');

	self::$db->query_write("
		INSERT IGNORE INTO `" . TABLE_PREFIX . "dbtech_downloads_extensiongroup` 
			(`extensiongroupid`, `title`) 
		VALUES 
			(1, 'Images'),
			(2, 'Files'),
			(3, 'Videos')
	");
	self::report('Populated Table', 'dbtech_downloads_extensiongroup');
}

if (self::$db_alter->fetch_table_info('dbtech_downloads_download'))
{
	self::$db_alter->drop_field('files');
	self::report('Altered Table', 'dbtech_downloads_download');
}

if (self::$db_alter->fetch_table_info('dbtech_downloads_file'))
{
	self::$db_alter->drop_field('private');
	self::$db_alter->drop_field('privateusers');

	self::$db_alter->add_field(array(
		'name'       => 'hashkey',
		'type'       => 'char',
		'length'     => '32',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => ''
	));

	if ($isUpgrade AND self::$db_alter->fetch_table_info('dbtech_downloads_filehash'))
	{
		self::$db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_downloads_file AS file
			SET hashkey = (
				SELECT `md5`
				FROM `" . TABLE_PREFIX . "dbtech_downloads_filehash` AS hash
				WHERE hash.fileid = file.fileid
			)
		");
	}
}

if ($isUpgrade)
{
	// Drop
	$tables = array(
		'categories',
		'comments',
		'extensions',
		'extension_groups',
		'favourites',
		'filegroup',
		'fileinfo',
		'filehash',
		'filequeue',
		'modules',
		'ratings',
	);
	foreach ($tables as $table)
	{
		self::$db->query_write("DROP TABLE IF EXISTS `" . TABLE_PREFIX . "dbtech_downloads_{$table}`");
		self::report('Deleted Table', 'dbtech_downloads_' . $table);
	}
}